/* sim_extension.h: SCP extension routines declarations

   Copyright (c) 2019-2023, J. David Bryan

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   Except as contained in this notice, the name of the author shall not be
   used in advertising or otherwise to promote the sale, use or other dealings
   in this Software without prior written authorization from the author.

   13-Mar-23    JDB     Added device cloning support
   28-Aug-22    JDB     Collected missing scp.h declarations here
   05-Jan-22    JDB     Added "ex_tmxr_connect" declaration
   23-Oct-21    JDB     Added "vm_align_trace" hook declaration
   06-May-21    JDB     Added missing externs to global declarations
   13-Mar-21    JDB     Added global declaration for "ex_attach_unit"
   12-Dec-20    JDB     Added global declaration for "vm_execution_rate"
   25-Aug-20    JDB     Declaration of "vm_sim_vm_init" is now conditional on USE_VM_INIT
   31-Dec-19    JDB     First release version
   18-Mar-19    JDB     Created file
*/



#include "sim_tmxr.h"



/* Extension remappings.

   These remappings cause the insertion of shims when a VM being compiled
   includes this declaration module.  The shims are not wanted when compiling
   the extension module itself.


   Implementation notes:

    1. When the extensions are being compiled, the module includes the
       "sim_serial.h" file, which includes the "sim_rs232.h" file.  Therefore,
       we do not want to include the latter file a second time and so exclude
       it when compiling the extensions module.
*/

#if ! defined (COMPILING_EXTENSIONS)

  #include "sim_rs232.h"

  #define sim_putchar        ex_sim_putchar
  #define sim_putchar_s      ex_sim_putchar_s
  #define sim_poll_kbd       ex_sim_poll_kbd

  #define sim_brk_test       ex_sim_brk_test
  #define attach_unit        ex_attach_unit

  #define tmxr_attach_unit   ex_tmxr_attach_unit
  #define tmxr_detach_unit   ex_tmxr_detach_unit
  #define tmxr_detach_line   ex_tmxr_detach_line
  #define tmxr_control_line  ex_tmxr_control_line
  #define tmxr_line_status   ex_tmxr_line_status
  #define tmxr_poll_conn     ex_tmxr_poll_conn
  #define tmxr_line_free     ex_tmxr_line_free
  #define tmxr_mux_free      ex_tmxr_mux_free
  #define tmxr_connect       ex_tmxr_connect

  #define sim_instr          vm_sim_instr
  #define sim_vm_init        vm_sim_vm_init
  #define sim_vm_cmd         vm_sim_vm_cmd

#endif


/* Redefinition of the modem signal type */

typedef RS232_SIGNAL TMCKT;                     /* declare a local name for the RS-232 signals type */


/* Connection notification descriptor */

typedef struct {                                /* connection descriptor */
    TMXR  *descriptor;                          /*   pointer to the multiplexer descriptor */
    void  (*connector) (int32 new_line);        /*   pointer to the VM-supplied connection routine */
    } EX_TMCONN;


/* Global extension routines */

extern t_stat ex_sim_putchar   (int32 c);
extern t_stat ex_sim_putchar_s (int32 c);
extern t_stat ex_sim_poll_kbd  (void);
extern uint32 ex_sim_brk_test  (t_addr location, uint32 type);
extern t_stat ex_attach_unit   (UNIT *uptr, char *cptr);

extern t_stat ex_tmxr_attach_unit  (TMXR *mp, UNIT *pptr, UNIT *uptr, char *cptr);
extern t_stat ex_tmxr_detach_unit  (TMXR *mp, UNIT *pptr, UNIT *uptr);
extern t_stat ex_tmxr_detach_line  (TMXR *mp, UNIT *uptr);
extern t_stat ex_tmxr_control_line (TMLN *lp, TMCKT control);
extern TMCKT  ex_tmxr_line_status  (TMLN *lp);
extern int32  ex_tmxr_poll_conn    (TMXR *mp);
extern t_bool ex_tmxr_line_free    (TMLN *lp);
extern t_bool ex_tmxr_mux_free     (TMXR *mp);
extern t_stat ex_tmxr_connect      (TMXR *mp, int32 *line);


/* The per-simulator init routine is declared (and called) only if the
   compilation defines the USE_VM_INIT symbol.  The other per-simulator pointers
   can be overridden by the init routine or by the CPU reset routine that is
   called during simulator startup, whichever is preferred.
*/

#if defined (USE_VM_INIT)
extern void (*vm_sim_vm_init) (void);
#endif

extern uint32 vm_execution_rate;                /* VM instruction execution rate */
extern t_stat vm_sim_instr (void);              /* VM instruction executor */
extern CTAB   *vm_sim_vm_cmd;                   /* VM-specific command table pointer */
extern UNIT   *vm_console_input_unit;           /* VM console input unit pointer */
extern UNIT   *vm_console_output_unit;          /* VM console output unit pointer */

extern uint32 (*vm_align_trace) (uint32 device_size, uint32 flag_size); /* VM trace alignment pointer */


/* Declarations that should be in scp.h */

#define SCPE_LAST           (SCPE_AFAIL + 1)

extern t_stat get_aval   (t_addr addr, DEVICE *dptr, UNIT *uptr);
extern t_stat show_break (FILE *st, DEVICE *dptr, UNIT *uptr, int32 flag, char *cptr);


/* Device clone support declarations that should be in sim_defs.h */

#define DEV_CLONE           (1u << DEV_V_UF - 1)    /* should be an assigned bit number */

typedef uint32 (*ADJUSTER) (DEVICE **dvptr, int32 delta);
